//////////////////////////////////////////////
// System.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkGraphicsTests.System = class System extends nkDebug.TestClass
{
	static instance = new System ("nkGraphicsTests.System") ;

	nkTests =
	{
		CreationDestructionSingleton : function ()
		{
			// Init
			const s = nkGraphics.System.getInstance() ;
			nkDebug.TestUtils.check(s.initialize(), "System initialization failure") ;

			// And shut down
			s.shutdown() ;
			nkGraphics.System.kill() ;
		},

		CreationDestructionIsolatedInstance : function ()
		{
			// Init
			const s = new nkGraphics.System () ;
			nkDebug.TestUtils.check(s.initialize(), "System initialization failure") ;

			// And shut down
			s.shutdown() ;
			s.delete() ;
		},

		FrameSingleton : function ()
		{
			// Init
			const s = nkGraphics.System.getInstance() ;
			nkDebug.TestUtils.check(s.initialize(), "System initialization failure") ;

			// Frame once to check sanity
			nkDebug.TestUtils.check(s.frame(null), "Frame failure") ;

			// And shut down
			s.shutdown() ;
			nkGraphics.System.kill() ;
		},

		FrameIsolatedInstance : function ()
		{
			// Init
			const s = new nkGraphics.System () ;
			nkDebug.TestUtils.check(s.initialize(), "System initialization failure") ;

			// Frame once to check sanity
			nkDebug.TestUtils.check(s.frame(null), "Frame failure") ;

			// And shut down
			s.shutdown() ;
			s.delete() ;
		}
	}
}